<?php
  $config = require __DIR__ . '/../../config.php';
  $appName = $config['app_name'] ?? 'LexForge';
  $u = current_user();
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?= e($appName) ?></title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-slate-50 text-slate-900">
  <header class="bg-white border-b">
    <div class="max-w-6xl mx-auto px-4 py-4 flex items-center justify-between">
      <div class="flex items-center gap-3">
        <div class="w-9 h-9 rounded-xl bg-slate-900 text-white flex items-center justify-center font-bold">LF</div>
        <div>
          <div class="font-semibold leading-5"><?= e($appName) ?></div>
          <div class="text-xs text-slate-500">Matter & Document Management</div>
        </div>
      </div>
      <?php if ($u): ?>
      <div class="flex items-center gap-3">
        <div class="text-sm text-slate-600 hidden sm:block">
          <?= e($u['full_name'] ?: $u['email']) ?> • <span class="uppercase text-xs"><?= e($u['role']) ?></span>
        </div>
        <a class="text-sm px-3 py-2 rounded-lg border hover:bg-slate-50" href="logout.php">Logout</a>
      </div>
      <?php endif; ?>
    </div>
  </header>
  <main class="max-w-6xl mx-auto px-4 py-6">
