<?php
require_login();

$id = (int)($_GET['id'] ?? 0);
$isEdit = $id > 0;

$name = $email = $phone = $address = '';
if ($isEdit) {
  $stmt = $db->prepare("SELECT * FROM clients WHERE id=?");
  $stmt->execute([$id]);
  $c = $stmt->fetch();
  if (!$c) { http_response_code(404); echo "Client not found"; exit; }
  $name = $c['name']; $email=$c['email']; $phone=$c['phone']; $address=$c['address'];
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check($_POST['_csrf'] ?? null);
  $name = trim($_POST['name'] ?? '');
  $email = trim($_POST['email'] ?? '');
  $phone = trim($_POST['phone'] ?? '');
  $address = trim($_POST['address'] ?? '');

  if ($name === '') {
    flash('err', 'Client name is required.');
  } else {
    if ($isEdit) {
      $stmt = $db->prepare("UPDATE clients SET name=?, email=?, phone=?, address=?, updated_at=? WHERE id=?");
      $stmt->execute([$name, $email ?: null, $phone ?: null, $address ?: null, now(), $id]);
      audit($db, 'client_update', null, "Updated client #$id");
      flash('ok', 'Client updated.');
    } else {
      $stmt = $db->prepare("INSERT INTO clients (name,email,phone,address,created_at,updated_at) VALUES (?,?,?,?,?,?)");
      $stmt->execute([$name, $email ?: null, $phone ?: null, $address ?: null, now(), now()]);
      $newId = (int)$db->lastInsertId();
      audit($db, 'client_create', null, "Created client #$newId");
      flash('ok', 'Client created.');
      redirect('index.php?r=client_edit&id=' . $newId);
    }
  }
}

include __DIR__ . '/../app/views/partials/header.php';
$err = flash('err');
$ok = flash('ok');
?>
<div class="flex items-center justify-between mb-5">
  <div>
    <h1 class="text-2xl font-semibold"><?= $isEdit ? 'Edit Client' : 'New Client' ?></h1>
    <p class="text-slate-600">Client profile and contact details.</p>
  </div>
  <a class="px-3 py-2 rounded-lg border bg-white hover:bg-slate-50" href="index.php?r=clients">Back</a>
</div>

<?php if ($err): ?><div class="mb-4 p-3 rounded-lg bg-red-50 border border-red-200 text-sm text-red-700"><?= e($err) ?></div><?php endif; ?>
<?php if ($ok): ?><div class="mb-4 p-3 rounded-lg bg-green-50 border border-green-200 text-sm text-green-700"><?= e($ok) ?></div><?php endif; ?>

<div class="bg-white border rounded-2xl p-6">
  <form method="post" class="grid grid-cols-1 md:grid-cols-2 gap-4">
    <input type="hidden" name="_csrf" value="<?= e(csrf_token()) ?>">
    <div class="md:col-span-2">
      <label class="text-sm font-medium">Client name *</label>
      <input name="name" value="<?= e($name) ?>" required class="mt-1 w-full px-3 py-2 rounded-lg border">
    </div>
    <div>
      <label class="text-sm font-medium">Email</label>
      <input name="email" value="<?= e($email) ?>" type="email" class="mt-1 w-full px-3 py-2 rounded-lg border">
    </div>
    <div>
      <label class="text-sm font-medium">Phone</label>
      <input name="phone" value="<?= e($phone) ?>" class="mt-1 w-full px-3 py-2 rounded-lg border">
    </div>
    <div class="md:col-span-2">
      <label class="text-sm font-medium">Address</label>
      <textarea name="address" class="mt-1 w-full px-3 py-2 rounded-lg border" rows="3"><?= e($address) ?></textarea>
    </div>
    <div class="md:col-span-2 flex gap-2">
      <button class="px-4 py-2 rounded-lg bg-slate-900 text-white"><?= $isEdit ? 'Save changes' : 'Create client' ?></button>
      <?php if ($isEdit): ?>
      <a class="px-4 py-2 rounded-lg border bg-white hover:bg-slate-50" href="index.php?r=matters&client_id=<?= (int)$id ?>">View matters</a>
      <?php endif; ?>
    </div>
  </form>
</div>

<?php include __DIR__ . '/../app/views/partials/footer.php'; ?>
