<?php
require_login();

$q = trim($_GET['q'] ?? '');
$params = [];
$sql = "SELECT * FROM clients";
if ($q !== '') {
  $sql .= " WHERE name LIKE ? OR email LIKE ? OR phone LIKE ?";
  $like = "%$q%";
  $params = [$like,$like,$like];
}
$sql .= " ORDER BY name ASC";

$stmt = $db->prepare($sql);
$stmt->execute($params);

include __DIR__ . '/../app/views/partials/header.php';
?>
<div class="flex items-center justify-between mb-5">
  <div>
    <h1 class="text-2xl font-semibold">Clients</h1>
    <p class="text-slate-600">Manage your client directory.</p>
  </div>
  <a class="px-3 py-2 rounded-lg border bg-white hover:bg-slate-50" href="index.php?r=client_new">+ New Client</a>
</div>

<form class="mb-4" method="get" action="index.php">
  <input type="hidden" name="r" value="clients">
  <div class="flex gap-2">
    <input class="w-full px-3 py-2 rounded-lg border" name="q" value="<?= e($q) ?>" placeholder="Search name, email, phone...">
    <button class="px-4 py-2 rounded-lg bg-slate-900 text-white">Search</button>
  </div>
</form>

<div class="bg-white border rounded-2xl overflow-hidden">
  <table class="w-full text-sm">
    <thead class="bg-slate-50 text-slate-600">
      <tr>
        <th class="text-left p-3">Name</th>
        <th class="text-left p-3">Email</th>
        <th class="text-left p-3">Phone</th>
        <th class="text-left p-3">Actions</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($stmt as $c): ?>
      <tr class="border-t">
        <td class="p-3 font-medium"><?= e($c['name']) ?></td>
        <td class="p-3"><?= e($c['email'] ?? '') ?></td>
        <td class="p-3"><?= e($c['phone'] ?? '') ?></td>
        <td class="p-3">
          <a class="underline" href="index.php?r=client_edit&id=<?= (int)$c['id'] ?>">Edit</a>
          <span class="mx-2 text-slate-300">|</span>
          <a class="underline" href="index.php?r=matters&client_id=<?= (int)$c['id'] ?>">Matters</a>
        </td>
      </tr>
      <?php endforeach; ?>
      <?php if ($stmt->rowCount() === 0): ?>
      <tr><td class="p-3 text-slate-500" colspan="4">No clients found.</td></tr>
      <?php endif; ?>
    </tbody>
  </table>
</div>

<?php include __DIR__ . '/../app/views/partials/footer.php'; ?>
