<?php
require_login();

$ref_no = 'MAT-' . date('Y') . '-' . strtoupper(bin2hex(random_bytes(2)));
$title = '';
$status = 'open';
$client_id = (int)($_GET['client_id'] ?? 0);

$clients = $db->query("SELECT id, name FROM clients ORDER BY name ASC")->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check($_POST['_csrf'] ?? null);
  $client_id = (int)($_POST['client_id'] ?? 0);
  $ref_no = trim($_POST['ref_no'] ?? '');
  $title = trim($_POST['title'] ?? '');
  $status = trim($_POST['status'] ?? 'open');

  if (!$client_id || $ref_no==='' || $title==='') {
    flash('err', 'Client, reference number and title are required.');
  } else {
    $stmt = $db->prepare("INSERT INTO matters (client_id, ref_no, title, status, description, created_at, updated_at) VALUES (?,?,?,?,?,?,?)");
    $stmt->execute([$client_id, $ref_no, $title, $status, null, now(), now()]);
    $mid = (int)$db->lastInsertId();
    // assign creator if not admin
    $u = current_user();
    if (!is_admin()) {
      $stmt = $db->prepare("INSERT IGNORE INTO matter_users (matter_id,user_id,created_at) VALUES (?,?,?)");
      $stmt->execute([$mid, $u['id'], now()]);
    }
    // default folders
    $folders = ['Pleadings','Correspondence','Evidence','Court','Contracts','Invoices'];
    $stmt = $db->prepare("INSERT INTO folders (matter_id, name, created_at) VALUES (?,?,?)");
    foreach ($folders as $f) $stmt->execute([$mid, $f, now()]);
    audit($db, 'matter_create', $mid, "Created matter #$mid");
    redirect('index.php?r=matter_view&id=' . $mid);
  }
}

include __DIR__ . '/../app/views/partials/header.php';
$err = flash('err');
?>
<div class="flex items-center justify-between mb-5">
  <div>
    <h1 class="text-2xl font-semibold">New Matter</h1>
    <p class="text-slate-600">Create a new case/matter and start uploading documents.</p>
  </div>
  <a class="px-3 py-2 rounded-lg border bg-white hover:bg-slate-50" href="index.php?r=matters">Back</a>
</div>

<?php if ($err): ?><div class="mb-4 p-3 rounded-lg bg-red-50 border border-red-200 text-sm text-red-700"><?= e($err) ?></div><?php endif; ?>

<div class="bg-white border rounded-2xl p-6">
  <form method="post" class="grid grid-cols-1 md:grid-cols-2 gap-4">
    <input type="hidden" name="_csrf" value="<?= e(csrf_token()) ?>">
    <div class="md:col-span-2">
      <label class="text-sm font-medium">Client *</label>
      <select name="client_id" required class="mt-1 w-full px-3 py-2 rounded-lg border">
        <option value="">Select client...</option>
        <?php foreach ($clients as $c): ?>
          <option value="<?= (int)$c['id'] ?>" <?= $client_id===(int)$c['id']?'selected':'' ?>><?= e($c['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div>
      <label class="text-sm font-medium">Reference number *</label>
      <input name="ref_no" value="<?= e($ref_no) ?>" required class="mt-1 w-full px-3 py-2 rounded-lg border">
    </div>
    <div>
      <label class="text-sm font-medium">Status</label>
      <select name="status" class="mt-1 w-full px-3 py-2 rounded-lg border">
        <?php foreach (['open','pending','closed'] as $s): ?>
          <option value="<?= e($s) ?>" <?= $status===$s?'selected':'' ?>><?= e($s) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="md:col-span-2">
      <label class="text-sm font-medium">Matter title *</label>
      <input name="title" value="<?= e($title) ?>" required class="mt-1 w-full px-3 py-2 rounded-lg border" placeholder="e.g. Mokoena v Mokoena – Divorce">
    </div>
    <div class="md:col-span-2">
      <button class="px-4 py-2 rounded-lg bg-slate-900 text-white">Create matter</button>
    </div>
  </form>
</div>

<?php include __DIR__ . '/../app/views/partials/footer.php'; ?>
