<?php
require_login();

$matter_id = (int)($_GET['id'] ?? 0);
if (!$matter_id) { redirect('index.php?r=matters'); }

if (!can_access_matter($db, $matter_id)) { http_response_code(403); echo "Access denied."; exit; }

$stmt = $db->prepare("SELECT m.*, c.name AS client_name FROM matters m JOIN clients c ON c.id=m.client_id WHERE m.id=?");
$stmt->execute([$matter_id]);
$m = $stmt->fetch();
if (!$m) { http_response_code(404); echo "Matter not found"; exit; }

$tab = $_GET['tab'] ?? 'documents';

$folders = $db->prepare("SELECT * FROM folders WHERE matter_id=? ORDER BY name ASC");
$folders->execute([$matter_id]);
$folders = $folders->fetchAll();

$docsStmt = $db->prepare("SELECT d.id, d.folder_id, f.name AS folder_name, d.title, d.original_name, d.mime_type, d.latest_version, d.created_at
                          FROM documents d JOIN folders f ON f.id=d.folder_id
                          WHERE d.matter_id=?
                          ORDER BY d.updated_at DESC, d.id DESC");
$docsStmt->execute([$matter_id]);
$docs = $docsStmt->fetchAll();

$staff = $db->prepare("SELECT u.id, u.full_name, u.email, r.name AS role
                       FROM matter_users mu JOIN users u ON u.id=mu.user_id
                       JOIN roles r ON r.id=u.role_id
                       WHERE mu.matter_id=? ORDER BY u.full_name ASC");
$staff->execute([$matter_id]);
$staff = $staff->fetchAll();

$allUsers = [];
if (is_admin()) {
  $allUsers = $db->query("SELECT u.id, u.full_name, u.email, r.name AS role
                          FROM users u JOIN roles r ON r.id=u.role_id
                          WHERE u.is_active=1 ORDER BY u.full_name ASC")->fetchAll();
  if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'assign') {
    csrf_check($_POST['_csrf'] ?? null);
    $uid = (int)($_POST['user_id'] ?? 0);
    if ($uid) {
      $stmt = $db->prepare("INSERT IGNORE INTO matter_users (matter_id,user_id,created_at) VALUES (?,?,?)");
      $stmt->execute([$matter_id, $uid, now()]);
      audit($db, 'matter_assign', $matter_id, "Assigned user #$uid");
      redirect('index.php?r=matter_view&id='.$matter_id.'&tab=staff');
    }
  }
  if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'unassign') {
    csrf_check($_POST['_csrf'] ?? null);
    $uid = (int)($_POST['user_id'] ?? 0);
    if ($uid) {
      $stmt = $db->prepare("DELETE FROM matter_users WHERE matter_id=? AND user_id=?");
      $stmt->execute([$matter_id, $uid]);
      audit($db, 'matter_unassign', $matter_id, "Unassigned user #$uid");
      redirect('index.php?r=matter_view&id='.$matter_id.'&tab=staff');
    }
  }
}

audit($db, 'matter_view', $matter_id, "Viewed matter #$matter_id");

include __DIR__ . '/../app/views/partials/header.php';
?>
<div class="flex items-start justify-between gap-4 mb-6">
  <div>
    <div class="text-sm text-slate-500"><?= e($m['client_name']) ?></div>
    <h1 class="text-2xl font-semibold"><?= e($m['ref_no']) ?> • <?= e($m['title']) ?></h1>
    <div class="mt-2 inline-flex text-xs px-2 py-1 rounded-full bg-slate-100"><?= e($m['status']) ?></div>
  </div>
  <div class="flex gap-2">
    <a class="px-3 py-2 rounded-lg border bg-white hover:bg-slate-50" href="index.php?r=upload&matter_id=<?= (int)$matter_id ?>">Upload</a>
    <a class="px-3 py-2 rounded-lg border bg-white hover:bg-slate-50" href="index.php?r=matters">Back</a>
  </div>
</div>

<div class="bg-white border rounded-2xl p-2 mb-4">
  <div class="flex gap-2 text-sm">
    <?php
      $tabs = [
        'documents' => 'Documents',
        'staff' => 'Staff',
      ];
      foreach ($tabs as $k=>$label):
        $active = ($tab===$k);
    ?>
      <a class="px-3 py-2 rounded-xl <?= $active ? 'bg-slate-900 text-white' : 'hover:bg-slate-50' ?>"
         href="index.php?r=matter_view&id=<?= (int)$matter_id ?>&tab=<?= e($k) ?>"><?= e($label) ?></a>
    <?php endforeach; ?>
  </div>
</div>

<?php if ($tab === 'documents'): ?>
  <div class="grid grid-cols-1 lg:grid-cols-3 gap-4">
    <div class="bg-white border rounded-2xl p-4">
      <div class="font-semibold mb-3">Folders</div>
      <div class="space-y-2">
        <?php foreach ($folders as $f): ?>
          <div class="p-2 rounded-xl bg-slate-50 border flex items-center justify-between">
            <div><?= e($f['name']) ?></div>
            <div class="text-xs text-slate-500">
              <?php
                $cntStmt = $db->prepare("SELECT COUNT(*) FROM documents WHERE folder_id=?");
                $cntStmt->execute([(int)$f['id']]);
                echo (int)$cntStmt->fetchColumn();
              ?>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
    </div>

    <div class="lg:col-span-2 bg-white border rounded-2xl overflow-hidden">
      <div class="p-4 border-b flex items-center justify-between">
        <div class="font-semibold">Documents</div>
        <div class="text-xs text-slate-500">Downloads are permission-checked and audited</div>
      </div>
      <table class="w-full text-sm">
        <thead class="bg-slate-50 text-slate-600">
          <tr>
            <th class="text-left p-3">Title</th>
            <th class="text-left p-3">Folder</th>
            <th class="text-left p-3">Version</th>
            <th class="text-left p-3">Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($docs as $d): ?>
          <tr class="border-t">
            <td class="p-3">
              <div class="font-medium"><?= e($d['title']) ?></div>
              <div class="text-xs text-slate-500"><?= e($d['original_name']) ?></div>
            </td>
            <td class="p-3"><?= e($d['folder_name']) ?></td>
            <td class="p-3">v<?= (int)$d['latest_version'] ?></td>
            <td class="p-3">
              <a class="underline" href="index.php?r=download&doc_id=<?= (int)$d['id'] ?>">Download</a>
            </td>
          </tr>
          <?php endforeach; ?>
          <?php if (count($docs)===0): ?>
          <tr><td class="p-3 text-slate-500" colspan="4">No documents yet. Click “Upload”.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
<?php elseif ($tab === 'staff'): ?>
  <div class="bg-white border rounded-2xl p-4">
    <div class="flex items-center justify-between mb-3">
      <div class="font-semibold">Matter staff</div>
      <?php if (!is_admin()): ?>
        <div class="text-xs text-slate-500">Only admins can assign staff</div>
      <?php endif; ?>
    </div>
    <div class="space-y-2">
      <?php foreach ($staff as $s): ?>
        <div class="p-3 rounded-xl border flex items-center justify-between">
          <div>
            <div class="font-medium"><?= e($s['full_name'] ?: $s['email']) ?></div>
            <div class="text-xs text-slate-500"><?= e($s['email']) ?> • <?= e($s['role']) ?></div>
          </div>
          <?php if (is_admin()): ?>
            <form method="post">
              <input type="hidden" name="_csrf" value="<?= e(csrf_token()) ?>">
              <input type="hidden" name="action" value="unassign">
              <input type="hidden" name="user_id" value="<?= (int)$s['id'] ?>">
              <button class="text-sm px-3 py-2 rounded-lg border hover:bg-slate-50">Remove</button>
            </form>
          <?php endif; ?>
        </div>
      <?php endforeach; ?>
      <?php if (count($staff)===0): ?>
        <div class="text-slate-500 text-sm">No staff assigned yet.</div>
      <?php endif; ?>
    </div>

    <?php if (is_admin()): ?>
      <div class="mt-6 pt-4 border-t">
        <div class="font-semibold mb-2">Assign user</div>
        <form method="post" class="flex gap-2">
          <input type="hidden" name="_csrf" value="<?= e(csrf_token()) ?>">
          <input type="hidden" name="action" value="assign">
          <select name="user_id" class="flex-1 px-3 py-2 rounded-lg border" required>
            <option value="">Select user...</option>
            <?php foreach ($allUsers as $u): ?>
              <option value="<?= (int)$u['id'] ?>"><?= e($u['full_name'] ?: $u['email']) ?> (<?= e($u['role']) ?>)</option>
            <?php endforeach; ?>
          </select>
          <button class="px-4 py-2 rounded-lg bg-slate-900 text-white">Assign</button>
        </form>
      </div>
    <?php endif; ?>
  </div>
<?php endif; ?>

<?php include __DIR__ . '/../app/views/partials/footer.php'; ?>
