<?php
require_login();

$client_id = (int)($_GET['client_id'] ?? 0);
$q = trim($_GET['q'] ?? '');

$params = [];
$sql = "SELECT m.*, c.name AS client_name
        FROM matters m JOIN clients c ON c.id=m.client_id";

$where = [];
if ($client_id > 0) { $where[] = "m.client_id=?"; $params[] = $client_id; }
if ($q !== '') { 
  $where[] = "(m.ref_no LIKE ? OR m.title LIKE ? OR c.name LIKE ?)";
  $like = "%$q%"; $params[]=$like; $params[]=$like; $params[]=$like;
}
if (!is_admin()) {
  $where[] = "EXISTS (SELECT 1 FROM matter_users mu WHERE mu.matter_id=m.id AND mu.user_id=?)";
  $params[] = current_user()['id'];
}

if ($where) $sql .= " WHERE " . implode(" AND ", $where);
$sql .= " ORDER BY m.created_at DESC";

$stmt = $db->prepare($sql);
$stmt->execute($params);

include __DIR__ . '/../app/views/partials/header.php';
?>
<div class="flex items-center justify-between mb-5">
  <div>
    <h1 class="text-2xl font-semibold">Matters</h1>
    <p class="text-slate-600">Track cases and related documents.</p>
  </div>
  <a class="px-3 py-2 rounded-lg border bg-white hover:bg-slate-50" href="index.php?r=matter_new">+ New Matter</a>
</div>

<form class="mb-4" method="get" action="index.php">
  <input type="hidden" name="r" value="matters">
  <?php if ($client_id): ?><input type="hidden" name="client_id" value="<?= (int)$client_id ?>"><?php endif; ?>
  <div class="flex gap-2">
    <input class="w-full px-3 py-2 rounded-lg border" name="q" value="<?= e($q) ?>" placeholder="Search ref, title, client...">
    <button class="px-4 py-2 rounded-lg bg-slate-900 text-white">Search</button>
  </div>
</form>

<div class="bg-white border rounded-2xl overflow-hidden">
  <table class="w-full text-sm">
    <thead class="bg-slate-50 text-slate-600">
      <tr>
        <th class="text-left p-3">Ref</th>
        <th class="text-left p-3">Matter</th>
        <th class="text-left p-3">Client</th>
        <th class="text-left p-3">Status</th>
        <th class="text-left p-3">Actions</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($stmt as $m): ?>
      <tr class="border-t">
        <td class="p-3 font-medium"><?= e($m['ref_no']) ?></td>
        <td class="p-3"><?= e($m['title']) ?></td>
        <td class="p-3"><?= e($m['client_name']) ?></td>
        <td class="p-3"><span class="text-xs px-2 py-1 rounded-full bg-slate-100"><?= e($m['status']) ?></span></td>
        <td class="p-3">
          <a class="underline" href="index.php?r=matter_view&id=<?= (int)$m['id'] ?>">Open</a>
        </td>
      </tr>
      <?php endforeach; ?>
      <?php if ($stmt->rowCount() === 0): ?>
      <tr><td class="p-3 text-slate-500" colspan="5">No matters found.</td></tr>
      <?php endif; ?>
    </tbody>
  </table>
</div>

<?php include __DIR__ . '/../app/views/partials/footer.php'; ?>
