<?php
require_login();

$matter_id = (int)($_GET['matter_id'] ?? 0);
if (!$matter_id) redirect('index.php?r=matters');
if (!can_access_matter($db, $matter_id)) { http_response_code(403); echo "Access denied."; exit; }

$stmt = $db->prepare("SELECT m.id, m.ref_no, m.title, c.name AS client_name
                      FROM matters m JOIN clients c ON c.id=m.client_id WHERE m.id=?");
$stmt->execute([$matter_id]);
$m = $stmt->fetch();
if (!$m) { http_response_code(404); echo "Matter not found"; exit; }

$folders = $db->prepare("SELECT id, name FROM folders WHERE matter_id=? ORDER BY name ASC");
$folders->execute([$matter_id]);
$folders = $folders->fetchAll();

$err = null; $ok = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check($_POST['_csrf'] ?? null);

  $folder_id = (int)($_POST['folder_id'] ?? 0);
  $title = trim($_POST['title'] ?? '');

  if (!$folder_id || $title==='') {
    $err = "Folder and title are required.";
  } elseif (!isset($_FILES['file']) || $_FILES['file']['error'] !== UPLOAD_ERR_OK) {
    $err = "File upload failed.";
  } else {
    // validate folder belongs to matter
    $check = $db->prepare("SELECT 1 FROM folders WHERE id=? AND matter_id=?");
    $check->execute([$folder_id, $matter_id]);
    if (!$check->fetchColumn()) {
      $err = "Invalid folder.";
    } else {
      $f = $_FILES['file'];
      $original = $f['name'];
      $tmp = $f['tmp_name'];
      $mime = mime_content_type($tmp) ?: 'application/octet-stream';
      $size = (int)$f['size'];

      // Create document record (or create new version if same title exists in same folder)
      $stmt = $db->prepare("SELECT id, latest_version FROM documents WHERE matter_id=? AND folder_id=? AND title=? LIMIT 1");
      $stmt->execute([$matter_id, $folder_id, $title]);
      $doc = $stmt->fetch();

      if ($doc) {
        $doc_id = (int)$doc['id'];
        $new_version = (int)$doc['latest_version'] + 1;
        $db->prepare("UPDATE documents SET latest_version=?, updated_at=? WHERE id=?")
           ->execute([$new_version, now(), $doc_id]);
        $action = 'doc_version_upload';
      } else {
        $db->prepare("INSERT INTO documents (matter_id, folder_id, title, original_name, mime_type, latest_version, created_at, updated_at)
                      VALUES (?,?,?,?,?,?,?,?)")
           ->execute([$matter_id, $folder_id, $title, $original, $mime, 1, now(), now()]);
        $doc_id = (int)$db->lastInsertId();
        $new_version = 1;
        $action = 'doc_upload';
      }

      $safeName = bin2hex(random_bytes(16));
      $ext = pathinfo($original, PATHINFO_EXTENSION);
      if ($ext) $safeName .= '.' . preg_replace('/[^a-zA-Z0-9]+/', '', $ext);

      $matterDir = storage_path() . '/matters/' . $matter_id;
      if (!is_dir($matterDir)) mkdir($matterDir, 0775, true);

      $dest = $matterDir . '/' . $doc_id . '_v' . $new_version . '_' . $safeName;
      if (!move_uploaded_file($tmp, $dest)) {
        $err = "Could not save file.";
      } else {
        $db->prepare("INSERT INTO document_versions (document_id, version_no, storage_path, original_name, mime_type, file_size, uploaded_by, uploaded_at)
                      VALUES (?,?,?,?,?,?,?,?)")
           ->execute([$doc_id, $new_version, $dest, $original, $mime, $size, current_user()['id'], now()]);
        audit($db, $action, $matter_id, "Document #$doc_id version v$new_version");
        $ok = "Uploaded successfully (v$new_version).";
      }
    }
  }
}

include __DIR__ . '/../app/views/partials/header.php';
?>
<div class="mb-5">
  <div class="text-sm text-slate-500"><?= e($m['client_name']) ?></div>
  <h1 class="text-2xl font-semibold">Upload document • <?= e($m['ref_no']) ?></h1>
  <p class="text-slate-600"><?= e($m['title']) ?></p>
</div>

<?php if ($err): ?><div class="mb-4 p-3 rounded-lg bg-red-50 border border-red-200 text-sm text-red-700"><?= e($err) ?></div><?php endif; ?>
<?php if ($ok): ?><div class="mb-4 p-3 rounded-lg bg-green-50 border border-green-200 text-sm text-green-700"><?= e($ok) ?></div><?php endif; ?>

<div class="bg-white border rounded-2xl p-6">
  <form method="post" enctype="multipart/form-data" class="grid grid-cols-1 md:grid-cols-2 gap-4">
    <input type="hidden" name="_csrf" value="<?= e(csrf_token()) ?>">
    <div class="md:col-span-2">
      <label class="text-sm font-medium">Folder *</label>
      <select name="folder_id" required class="mt-1 w-full px-3 py-2 rounded-lg border">
        <option value="">Select folder...</option>
        <?php foreach ($folders as $f): ?>
          <option value="<?= (int)$f['id'] ?>"><?= e($f['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="md:col-span-2">
      <label class="text-sm font-medium">Document title *</label>
      <input name="title" required class="mt-1 w-full px-3 py-2 rounded-lg border" placeholder="e.g. Founding affidavit">
      <div class="text-xs text-slate-500 mt-1">Uploading another file with the same title in the same folder creates a new version.</div>
    </div>
    <div class="md:col-span-2">
      <label class="text-sm font-medium">File *</label>
      <input type="file" name="file" required class="mt-1 w-full px-3 py-2 rounded-lg border bg-white">
    </div>
    <div class="md:col-span-2 flex gap-2">
      <button class="px-4 py-2 rounded-lg bg-slate-900 text-white">Upload</button>
      <a class="px-4 py-2 rounded-lg border bg-white hover:bg-slate-50" href="index.php?r=matter_view&id=<?= (int)$matter_id ?>">Back to matter</a>
    </div>
  </form>
</div>

<?php include __DIR__ . '/../app/views/partials/footer.php'; ?>
