<?php
require __DIR__ . '/../app/bootstrap.php';

if (current_user()) redirect('index.php');

$error = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check($_POST['_csrf'] ?? null);
  $email = $_POST['email'] ?? '';
  $pass  = $_POST['password'] ?? '';
  if (login($db, $email, $pass)) {
    redirect('index.php');
  } else {
    $error = "Invalid login.";
    // do not audit failed logins with full details; just count
    $stmt = $db->prepare("INSERT INTO audit_logs (user_id, action, matter_id, details, ip_address, user_agent, created_at)
                          VALUES (NULL, 'login_failed', NULL, 'Invalid credentials', ?, ?, ?)");
    $stmt->execute([client_ip(), user_agent(), now()]);
  }
}

include __DIR__ . '/../app/views/partials/header.php';
?>
<div class="max-w-md mx-auto">
  <div class="bg-white border rounded-2xl p-6 shadow-sm">
    <h1 class="text-xl font-semibold mb-1">Sign in</h1>
    <p class="text-sm text-slate-600 mb-5">Access your matters and documents securely.</p>

    <?php if ($error): ?>
      <div class="mb-4 p-3 rounded-lg bg-red-50 border border-red-200 text-sm text-red-700"><?= e($error) ?></div>
    <?php endif; ?>

    <form method="post" class="space-y-4">
      <input type="hidden" name="_csrf" value="<?= e(csrf_token()) ?>">
      <div>
        <label class="text-sm font-medium">Email</label>
        <input name="email" type="email" required class="mt-1 w-full px-3 py-2 rounded-lg border" placeholder="name@firm.co.za">
      </div>
      <div>
        <label class="text-sm font-medium">Password</label>
        <input name="password" type="password" required class="mt-1 w-full px-3 py-2 rounded-lg border" placeholder="••••••••">
      </div>
      <button class="w-full bg-slate-900 text-white px-4 py-2 rounded-lg hover:bg-slate-800">Sign in</button>
      <div class="text-xs text-slate-500">Tip: After installation, change the default admin password.</div>
    </form>
  </div>
</div>
<?php include __DIR__ . '/../app/views/partials/footer.php'; ?>
